import com.intellij.database.model.DasObjectWithSource
import com.intellij.database.model.DasSchemaChild
import com.intellij.database.model.ObjectKind

LAYOUT.ignoreDependencies = true
LAYOUT.baseName { ctx -> baseName(ctx.object) }


def baseName(obj) {
  def folder = folderName(obj)
  def file = fileName(obj)

  if (folder.isEmpty()) {
    return file
  }
  else {
    return folder + "/" + file
  }
}

def fileName(obj) {
  for (def cur = obj; cur != null; cur = cur.dasParent) {
    if (storeSeparately(cur)) return sanitize(cur.name)
  }
  return sanitize(obj.name)
}

static def folderName(obj) {
  if (obj.getKind() == ObjectKind.TRIGGER) return "Database Triggers"
  if (obj.getKind() == ObjectKind.VIEW) return "Views"
  if (obj.getKind() == ObjectKind.ROUTINE) return "Stored Procedures"
  if (obj.getKind() == ObjectKind.RULE) return "Rules"
  if (obj.getKind() == ObjectKind.SEQUENCE) return "Sequences"
  if (obj.getKind() == ObjectKind.SCHEMA) return "Security"
  if (obj.getKind() == ObjectKind.USER) return "Security"
  if (obj.getKind() == ObjectKind.ROLE) return "Security"
  if (obj.getKind() == ObjectKind.LOGIN) return "Security"
  if (obj.getKind() == ObjectKind.SECURITY_POLICY) return "Security"
  if (obj.getKind() == ObjectKind.SECURITY_PREDICATE) return "Security"
  if (obj.getKind() == ObjectKind.LINKED_SERVER) return "Server Objects"
  if (obj.getKind() == ObjectKind.DATA_FILE) return "Storage"
  if (obj.getKind() == ObjectKind.SYNONYM) return "Synonyms"
  if (obj.getKind() == ObjectKind.TABLE) return "Tables"
  if (obj.getKind() == ObjectKind.INDEX) return "Tables"
  if (obj.getKind() == ObjectKind.FOREIGN_KEY) return "Tables"
  if (obj.getKind() == ObjectKind.KEY) return "Tables"
  if (obj.getKind() == ObjectKind.CHECK) return "Tables"
  if (obj.getKind() == ObjectKind.DEFAULT) return "Tables"
  if (obj.getKind() == ObjectKind.TABLE_TYPE) return "User Defined Types"
  return ""
}

static def storeSeparately(obj) {
  return obj instanceof DasObjectWithSource || obj instanceof DasSchemaChild
}

def sanitize(name) {
  return name.replace('/', 'slash')
}